const fs = require("fs");
const axios = require("axios");
const ffmpegPath = require("@ffmpeg-installer/ffmpeg").path;
const ffmpeg = require("fluent-ffmpeg");
const videoshow = require("videoshow");

ffmpeg.setFfmpegPath(ffmpegPath);

/**
 * @function formatStringToSec
 * @description Formats String-{hh:mm:ss} to seconds format
 * @param {String} 'hh:mm:ss'
 * @returns {Number} seconds
 */
function formatStringToSec(timeString = "00:00:00") {
  //param should be in format HH:MM:SS
  let seconds = 0;
  timeString
    .trim()
    .split(":")
    .reverse()
    .forEach((time, index) => {
      if (index === 0) {
        seconds += +time;
      } else {
        seconds += +time * (index * 60);
      }
    });
  console.log(
    "HH:MM:SS -> " + timeString + " => converted to seconds : " + seconds
  );
  return seconds;
}

/**
 * @function downloadImage
 * @description Downloads an image from a given URL to the specified path
 * @param {String} imageUrl - URL of the image to be downloaded
 * @param {String} imagePath - Path where the image will be saved
 * @returns {Promise} - Returns a Promise that resolves when the image is downloaded successfully
 */
async function downloadImage(imageUrl, imagePath) {
  const response = await axios({
    method: "GET",
    url: imageUrl,
    responseType: "stream",
  });

  return new Promise((resolve, reject) => {
    const stream = response.data.pipe(fs.createWriteStream(imagePath));
    stream.on("finish", () => resolve(imagePath)); // Resolve with imagePath
    stream.on("error", reject);
  });
}

/**
 * @function createVideoFromImages
 * @description Creates a video from a set of images
 * @param {String[]} imageUrls - URLs of the images to be included in the video
 * @param {String} outputVideoPath - Path where the output video will be saved
 * @param {Number} fps - Frames per second for the video
 * @returns {Promise} - Returns a Promise that resolves when the video is created successfully
 */
async function createVideoFromImages(
  imageUrls,
  outputVideoPath,
  fps = 10 // Lower FPS for demonstration purpose
) {
  const duration = imageUrls.length / fps; // Calculate duration based on number of images and fps
  const imagePaths = [];
  for (let i = 0; i < imageUrls.length; i++) {
    const imagePath = `./input_video/image_${i}.jpg`; // Assuming all images will be JPEG format
    const downloadedImagePath = await downloadImage(imageUrls[i], imagePath);
    imagePaths.push(downloadedImagePath);
  }
  const command = ffmpeg();
  for (let i = 0; i < imagePaths.length; i++) {
    command.input(imagePaths[i]);
  }
  command
    .fps(fps)
    .duration(duration) // Set the duration based on the number of images and fps
    .outputOptions([
      "-c:v h264",
      "-profile:v main",
      `-vf scale=1280:-2`,
      "-hls_list_size 0",
      "-start_number 0",
      "-hls_time 10",
      "-loglevel error",
    ])
    .output(outputVideoPath);
  return new Promise((resolve, reject) => {
    command
      .on("end", () => resolve())
      .on("error", (err) => reject(err))
      .run();
  });
}

/**
 * @function trimVideo
 * @description Trims video from start time to end time
 * @param {String} startTime - Start time in 'hh:mm:ss' format
 * @param {String} endTime - End time in 'hh:mm:ss' format
 * @param {String} inputVideoPath - Path of the input video file
 * @param {String} outputVideoPath - Path where the trimmed video will be saved
 * @returns {Promise} - Returns a Promise that resolves when the video is trimmed successfully
 */
function trimVideo(
  startTime = "00:00:00",
  endTime = "00:00:00",
  inputVideoPath,
  outputVideoPath
) {
  const startSec = formatStringToSec(startTime);
  const endSec = formatStringToSec(endTime);
  const duration = endSec - startSec;
  return new Promise((resolve, reject) => {
    ffmpeg(inputVideoPath)
      .setStartTime(startTime)
      .setDuration(duration.toString())
      .output(outputVideoPath)
      // Additional options for output codec and parameters
      .outputOptions([
        "-c:v libx264", // Output video codec
        "-crf 20", // Constant Rate Factor (quality) - adjust as needed
        "-preset fast", // Preset for encoding speed - adjust as needed
        "-pix_fmt yuv420p", // Remove the period at the end
      ])
      .on("end", () => {
        console.log("Trimming completed successfully.");
        resolve();
      })
      .on("error", (err) => {
        console.error("Error trimming video:", err);
        reject(err);
      });
  });
}

// Example usage:

const imageUrls = [
  "https://www.shutterstock.com/shutterstock/photos/763789297/display_1500/stock-vector-detailed-vector-illustration-silhouettes-of-expressive-dance-people-dancing-jazz-funk-hip-hop-763789297.jpg",
  "https://www.shutterstock.com/shutterstock/photos/106751819/display_1500/stock-photo-eastern-lubber-grasshopper-white-background-106751819.jpg",
];

const inputVideoPath = "./input_video/input.mp4";
const outputVideoPath = "./output_video/output.mp4";

// createVideoFromImages(imageUrls, outputVideoPath)
//   .then(() => {
//     console.log("Video created from images successfully!");
//     return trimVideo("00:00:05", "00:00:10", outputVideoPath, outputVideoPath);
//   })
//   .then(() => console.log("Video trimmed successfully!"))
//   .catch((err) => console.error("Error:", err));

const imagePaths = [];
for (let i = 0; i < imageUrls.length; i++) {
  const imagePath = `./input_video/image_${i}.jpg`; // Assuming all images will be JPEG format
  const downloadedImagePath = downloadImage(imageUrls[i], imagePath);
  imagePaths.push(downloadedImagePath);
}
var videoOptions = {
  fps: 25,
  transition: true,
  transitionDuration: 1, // seconds
  videoBitrate: 1024,
  videoCodec: "libx264",
  size: "640x?",
  audioBitrate: "128k",
  audioChannels: 2,
  format: "mp4",
  pixelFormat: "yuv420p",
  loop: 3, // seconds,
};

const lastDot = "Ahsan";
const prev_file_folder = "";
const new_upload = Date.now() + ".mp4";
console.log(new_upload);

videoshow(imagePaths, videoOptions)
  .save(new_upload)
  // store_upload.single(new_upload)
  // .on('start', (command) => {
  //     console.log('ffmpeg' + command)
  // })
  // .on('error', (err) => {

  //     console.log(err)
  //     res.status(400)
  // })
  .on("end", (command) => {
    console.log(command);

    res.locals = { new_upload, prev_file_folder };
    console.log("fm");
    console.log(res.locals);
    next();
  });
