const multer = require('multer');
const path = require('path');

// Multer configuration for storing images
const storage = multer.diskStorage({
    destination: function (req, file, cb) {
        cb(null, './input_images'); // Define the destination folder where images will be stored
    },
    filename: function (req, file, cb) {
        cb(null, Date.now() + path.extname(file.originalname)); // Define the filename
    }
});

// Filter function to restrict file types
const fileFilter = (req, file, cb) => {
    if (file.mimetype.startsWith('image/')) {
        cb(null, true);
    } else {
        cb(new Error('Only images are allowed!'), false);
    }
};

// Set up multer
const upload = multer({ storage: storage, fileFilter: fileFilter });

// Export the upload middleware
module.exports.fileupload = upload;
